using System;
using System.Collections.Generic;
using System.Text;

namespace ManageTypes
{
    class Program
    {
        static void Main(string[] args)
        {
            // create an accessor to SensorManager
            SensorManager.Service sensorManager = new SensorManager.Service();
            // create an accessor to UserManager
            UserManager.Service userManager = new UserManager.Service();

            /*
             * authenticate yourself with SenseWeb and get a temporary 
             * passCode (expire in 10 minutes)
             */
            // TODO: replace the fake username and passwd with real ones
            string userName = "yourUserName";
            string passwd = "yourPasswd";
            Guid passCode = userManager.GetPassCode(userName, passwd);

            /*
             * register a non-vector sensor type
             */
            string sensorTypeName = "yourSensorTypeName";
            string sensorTypeUri = "yourSensorUri";
            string output = sensorManager.CreateSensorType(userName, passCode, sensorTypeName, sensorTypeUri);
            Console.WriteLine(output);

            /* 
             * register a vector sensor type (component sensor types given by names)
             */
            string vectorSensorTypeName = "yourVectorSenosrTypeName";
            string vectorSensorTypeUri = "yourVectorSenosrTypeUri";
            // define the component types of the vector type by using the names of the component types
            string[] componentTypesByNames = new string[3] { "Temperature", "Humidity", "Pressure" };
            output = sensorManager.CreateVectorSensorType(userName, passCode, vectorSensorTypeName, vectorSensorTypeUri, componentTypesByNames);
            Console.WriteLine(output);
            ;
        }
    }
}