using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace DHLib
{
    public class DataHub
    {
        DataManager _dataManager = new DataManager();

        public SensorData[] GetLatestScalarDataInBatch(string[] publisherNames, string[] sensorNames)
        {
            return _dataManager.GetLatestScalarDataInBatch(publisherNames, sensorNames);
        }

        public SensorData[] GetScalarDataSeriesInBatch(string[] publisherNames, string[] sensorNames, DateTime startTime, DateTime endTime)
        {
            return _dataManager.GetScalarDataSeriesInBatch(publisherNames, sensorNames, startTime, endTime);
        }

        public SensorData[] GetAggregateScalarDataInBatch(string[] publisherNames, string[] sensorNames, DateTime startTime, DateTime endTime)
        {
            return _dataManager.GetAggregateScalarDataInBatch(publisherNames, sensorNames, startTime, endTime);
        }

        public SensorData[] GetAggregateScalarDataSeriesInBatch(string[] publisherNames, string[] sensorNames, DateTime startTime, DateTime endTime, int aggregateIntervalInSeconds)
        {
            return _dataManager.GetAggregateScalarDataSeriesInBatch(publisherNames, sensorNames, startTime, endTime, aggregateIntervalInSeconds);
        }
    }
}