using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Configuration;
using System.Collections.Generic;

using DHLib;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class Service : System.Web.Services.WebService
{
    private DataHub datahub = new DataHub();

    [WebMethod(Description = "Get latest data published by a set of sensors")]
    public SensorData[] GetLatestScalarDataInBatch(string[] publisherNames, string[] sensorNames)
    {
        return datahub.GetLatestScalarDataInBatch(publisherNames, sensorNames);
    }

    [WebMethod(Description = "Get a series of data published by a set of sensors within a specified time window")]
    public SensorData[] GetScalarDataSeriesInBatch(string[] publisherNames, string[] sensorNames, DateTime startTime, DateTime endTime)
    {
        return datahub.GetScalarDataSeriesInBatch(publisherNames, sensorNames, startTime, endTime);
    }

    [WebMethod(Description = "Get aggregate data published by a set of sensors within a specified time window")]
    public SensorData[] GetAggregateScalarDataInBatch(string[] publisherNames, string[] sensorNames, DateTime startTime, DateTime endTime)
    {
        return datahub.GetAggregateScalarDataInBatch(publisherNames, sensorNames, startTime, endTime);
    }

    [WebMethod(Description = "Get a series of aggregate data published by a set of sensors within a specified time window")]
    public SensorData[] GetAggregateScalarDataSeriesInBatch(string[] publisherNames, string[] sensorNames, DateTime startTime, DateTime endTime, int aggregateIntervalInSeconds)
    {
        return datahub.GetAggregateScalarDataSeriesInBatch(publisherNames, sensorNames, startTime, endTime, aggregateIntervalInSeconds);
    }
}