using System;
using System.Collections.Generic;
using System.Text;

namespace TestApplicationManager
{
    class Program
    {
        static void Main(string[] args)
        {
            // create an accessor to web services of ApplicationManager
            ApplicationManager.Service appManager = new ApplicationManager.Service();

            /*
             * authenticate yourself with SenseWeb and get a temporary passCode (expire in 10 minutes)
             */
            // TODO: replace the fake username and passwd with real ones
            string userName = "yourUserName";
            string passwd = "yourPasswd";
            UserManager.Service userManager = new UserManager.Service();
            string passCode = userManager.GetPassCode(userName, passwd).ToString();

            /*
             * Get the list of sensors by query
             */
            // create the list of points that define a polygon
            ApplicationManager.PointF[] polygon = new ApplicationManager.PointF[4];
            polygon[0] = new ApplicationManager.PointF();
            polygon[0].lat = 47.00;
            polygon[0].lon = -122.00;
            polygon[1] = new ApplicationManager.PointF();
            polygon[1].lat = 47.00;
            polygon[1].lon = -123.00;
            polygon[2] = new ApplicationManager.PointF();
            polygon[2].lat = 48.00;
            polygon[2].lon = -123.00;
            polygon[3] = new ApplicationManager.PointF();
            polygon[3].lat = 48.00;
            polygon[3].lon = -122.00;

            // we are interested in traffic sensors
            int[] types = { 4, 2 }; // 4:traffic, 2:temperature

            ApplicationManager.SensorInfo[] sensors = appManager.GetSensorsByPolygonQuery(polygon, polygon, "", types);

            if (sensors != null)
            {
                for (int i = 0; i < sensors.Length; i ++)
                {
                    Console.WriteLine("Sensor " + i + ":"
                                      + sensors[i].sensorName + ","
                                      + sensors[i].publisherName + ";");
                }
            }

            /*
             * Get the most recent readings and the list of sensors defined by query
             */

            ApplicationManager.SensorInfoAndDataList sensorAndData = appManager.GetDataByPolygonQuery(polygon, polygon, "", types);
            if (sensorAndData != null)
            {
                int length = Math.Min(sensorAndData.Sensors.Length, sensorAndData.Data.Length);
                for (int i = 0; i < length; i++)
                {
                    if (sensorAndData.Sensors[i] != null)
                        Console.Write(i + " - Sensor:"
                                          + sensorAndData.Sensors[i].sensorName + ","
                                          + sensorAndData.Sensors[i].publisherName + ";");
                    if (sensorAndData.Data[i] != null && sensorAndData.Data[i].Timestamps != null)
                        Console.Write(" Data" + i + ":"
                                          + sensorAndData.Data[i].Timestamps[0] + ","
                                          + sensorAndData.Data[i].Data[0] + ";");
                    Console.WriteLine();
                }
            }


            /*
             * Get the most recent readings and the list of sensors defined by query
             */

            sensorAndData = appManager.GetAggregateDataByPolygonQuery(polygon, polygon, "", types
                , new DateTime(2006, 1, 1), new DateTime(2007, 1, 1));
            if (sensorAndData != null)
            {
                int length = Math.Min(sensorAndData.Sensors.Length, sensorAndData.Data.Length);
                for (int i = 0; i < length; i++)
                {
                    if (sensorAndData.Sensors[i] != null)
                        Console.Write(i + " - Sensor:"
                                          + sensorAndData.Sensors[i].sensorName + ","
                                          + sensorAndData.Sensors[i].publisherName + ";");
                    if (sensorAndData.Data[i] != null && sensorAndData.Data[i].Timestamps != null)
                        Console.Write(" Data" + i + ":"
                                          + sensorAndData.Data[i].Timestamps[0] + ","
                                          + sensorAndData.Data[i].Data[0] + ";");
                    Console.WriteLine();
                }
            }
            ;
        }
    }
}
