/*
 * DataTypes:
 * "unknown" 0
 * "scalar" 1
 * "vector" 5
 * "html" 6
 * "image" 7
 */
using System;
using System.Collections.Generic;
using System.Text;

namespace TestDataHub
{
    class Program
    {
        /// <summary>
        /// Register, update, and delete a non-vector sensor
        /// </summary>
        static void ManageNonVectorSensor(DataHub.Service dataHub, string userName, Guid passCode)
        {
            // this is a themometer sensor
            string sensorTypeUri = "http://research.microsoft.com/nec/sensor/type/SensorType.owl#Thermometer";
            string sensorName = "yourSensorName";
            string sensorURL = "yourSensorURL";
            string sensorDescription = "yourSensorDescription";
            double latitude = -1;
            double longitude = -1;
            double altitude = -1;

            // declare a new sensor
            DataHub.SensorInfo sensor = new DataHub.SensorInfo();
            sensor.dataType = "scalar";
            sensor.sensorType = sensorTypeUri;
            sensor.publisherName = userName;
            sensor.sensorName = sensorName;
            //url is optional for scalar sensors, but required for image and html sensors
            sensor.url = sensorURL; 
            sensor.description = sensorDescription;
            sensor.latitude = latitude;
            sensor.longitude = longitude;
            sensor.altitude = altitude;

            // register the sensor
            string output = dataHub.RegisterSensor(userName, passCode, sensor);
            Console.WriteLine(output);

            // get the sensor by name
            output = dataHub.GetSensorByPublisherAndName(userName, sensorName).description;
            Console.WriteLine(output);

            // update the location of the sensor
            double newLatitude = 0;
            double newLongitude = 0;
            double newAltitude = 0;
            output = dataHub.UpdateSensorLocation(userName, passCode, sensorName, newLatitude, newLongitude, newAltitude);
            Console.WriteLine(output);

            // get sensor description by name
            output = dataHub.GetSensorByPublisherAndName(userName, sensorName).description;
            Console.WriteLine(output);

            // delete the sensor
            output = dataHub.DeleteSensor(userName, passCode, sensorName);
            Console.WriteLine(output);
        }

        /// <summary>
        /// Register and delete a vector sensor
        /// </summary>
        static void ManageVectorSensor(DataHub.Service dataHub, string userName, Guid passCode)
        {
            // this is a vector sensor of type testV
            string sensorTypeName = "testV";
            string sensorName = "yourVectorSensorName";
            string sensorURL = "yourVectorSensorURL";
            string sensorDescription = "yourVectorSensorDescription";
            double latitude = -1;
            double longitude = -1;
            double altitude = -1;

            // decare a new sensor
            DataHub.SensorInfo sensor = new DataHub.SensorInfo();
            sensor.dataType = "vector";
            sensor.sensorType = sensorTypeName;
            sensor.publisherName = userName;
            sensor.sensorName = sensorName;
            sensor.url = sensorURL;
            sensor.description = sensorDescription;
            sensor.latitude = latitude;
            sensor.longitude = longitude;
            sensor.altitude = altitude;

            // register the sensor
            string output = dataHub.RegisterVectorSensor(userName, passCode, sensor);
            Console.WriteLine(output);

            // get sensor description by name
            output = dataHub.GetSensorByPublisherAndName(userName, sensorName).description;
            Console.WriteLine(output);

            // delete the sensor
            output = dataHub.DeleteVectorSensor(userName, passCode, sensorName, sensorTypeName);
            Console.WriteLine(output);
        }

        /// <summary>
        /// Store and get scalar data for a single sensor or a batch of sensors
        /// </summary>
        static void ManageScalarData(DataHub.Service dataHub, string userName, Guid passCode)
        {
            // this is a themometer sensor
            string sensorTypeUri = "http://research.microsoft.com/nec/sensor/type/SensorType.owl#Thermometer";
            string sensorURL = "yourSensorURL";
            string sensorDescription = "yourSensorDescription";
            double latitude = -1;
            double longitude = -1;
            double altitude = -1;

            // decare and register sensor 1 named yourSensorName1
            string sensorName1 = "yourSensorName1";
            DataHub.SensorInfo sensor = new DataHub.SensorInfo();
            sensor.dataType = "scalar";
            sensor.sensorType = sensorTypeUri;
            sensor.publisherName = userName;
            sensor.sensorName = sensorName1;
            sensor.url = sensorURL;
            sensor.description = sensorDescription;
            sensor.latitude = latitude;
            sensor.longitude = longitude;
            sensor.altitude = altitude;
            string output = dataHub.RegisterSensor(userName, passCode, sensor);
            Console.WriteLine(output);

            // decare and register sensor 2 named yourSensorName2
            string sensorName2 = "yourSensorName2";
            sensor.sensorName = sensorName2;
            output = dataHub.RegisterSensor(userName, passCode, sensor);
            Console.WriteLine(output);

            // store scalar data from Sensor 1 into DataHub
            DataHub.SensorData sensorDataToStore = new DataHub.SensorData();
            sensorDataToStore.DataType = 1; // scalar
            sensorDataToStore.Data = new double[] { 11 };
            sensorDataToStore.Timestamps = new DateTime[] { DateTime.Now };
            output = dataHub.StoreScalarData(userName, passCode, sensorName1, sensorDataToStore);
            Console.WriteLine(output);

            // get the latest scalar data of Sensor 1
            DataHub.SensorData sensorDataRetrieved = dataHub.GetLatestScalarData(userName, sensorName1);
            Console.WriteLine("Latest scalar data from Sensor 1: "
                            + sensorDataRetrieved.Data[0]);

            // store scalar data of multiple sensors (sensor 1 and sensor 2) as a batch
            string[] userNameArray = {userName, userName};
            Guid[] passCodeArray = {passCode, passCode};
            string[] sensorNameArray = {sensorName1, sensorName2};
            DataHub.SensorData[] sensorDataArray = new DataHub.SensorData[2];
            sensorDataArray[0] = new DataHub.SensorData();
            sensorDataArray[0].Data = new double[] { 12 };
            sensorDataArray[0].DataType = 1; // scalar
            sensorDataArray[0].Timestamps = new DateTime[] { DateTime.Now };
            sensorDataArray[1] = new DataHub.SensorData();
            sensorDataArray[1].Data = new double[] { 22 };
            sensorDataArray[1].DataType = 1; // scalar
            sensorDataArray[1].Timestamps = new DateTime[] { DateTime.Now };
            output = dataHub.StoreScalarDataBatch(userNameArray, passCodeArray, sensorNameArray, sensorDataArray);
            Console.WriteLine(output);

            // get the latest scalar data of multiple sensors as a batch
            DataHub.SensorData[] sensorDataArrayRetrieved = dataHub.GetLatestScalarDataInBatch(userNameArray, sensorNameArray);
            Console.WriteLine("Latest scalar data from Sensor 1 and 2: "
                            + sensorDataArrayRetrieved[0].Data[0]
                            + "," + sensorDataArrayRetrieved[1].Data[0]);

            // delete sensor 1
            output = dataHub.DeleteSensor(userName, passCode, sensorName1);
            Console.WriteLine(output);

            // delete sensor 2
            output = dataHub.DeleteSensor(userName, passCode, sensorName2);
            Console.WriteLine(output);
        }

        static void Main(string[] args)
        {
            // create an accessor to web services of DataHub
            DataHub.Service dataHub = new DataHub.Service();
            // create an accessor to user manager of DataHub
            UserManagerDH.Service userManagerDH = new UserManagerDH.Service();

            // authenticate yourself to get a temporary pass code (good for 10 mininutes)
            // TODO: replace the fake username and passwd with real ones
            string userName = "yourUserName";
            string passwd = "yourPasswd";
            Guid passCode = userManagerDH.GetPassCode(userName, passwd);

            // execute examples
            ManageNonVectorSensor(dataHub, userName, passCode);
            ManageVectorSensor(dataHub, userName, passCode);
            ManageScalarData(dataHub, userName, passCode);
        }
    }
}
