using System;
using System.Collections.Generic;
using System.Text;

namespace TestSensorManager
{
    class Program
    {
        static void ManagerNonVectorTypesAndSensors(SensorManager.Service sensorManager, string userName, Guid passCode)
        {
            string output;

            /*
             * register a non-vector sensor type
             */
            string sensorTypeName = "yourSensorTypeName";
            string sensorTypeUri = "yourSensorUri";
            output = sensorManager.CreateSensorType(userName, passCode, sensorTypeName, sensorTypeUri);
            Console.WriteLine(output);

            /*
             * register a non-vector sensor
             */
            // assume this is a sensor of the newly created type - sensorTypeUri
            string sensorName = "yourSensorName";
            string originalPublisherName = "yourPublisherName";
            double latitude = -1;
            double longitude = -1;
            double altitude = -1;
            string sensorURL = "yourSensorURL";
            string sensorKeywords = "yourSensorKeywords";
            string sensorDescription = "yourSensorDescription";

            // define a new sensor
            SensorManager.SensorInfo sensor = new SensorManager.SensorInfo();
            sensor.dataType = "scalar";
            sensor.sensorType = sensorTypeUri;
            // publisherName is the user name of the original publisher with repect to a gateway
            // (publisherName + sensorName) uniquely identifies a sensor within a gateway
            // (userName + publisherName + sensorName) uniquely identifies a sensor within SenseWeb
            sensor.publisherName = originalPublisherName;
            sensor.sensorName = sensorName;
            sensor.latitude = latitude;
            sensor.longitude = longitude;
            sensor.altitude = altitude;
            // webServiceUrl is the web service URL of your own sensor gateway.
            // If you plan to use DataHub as your sensor gateway, use the following URL as it is.
            sensor.webServiceUrl = "http://localhost/SenseWebV3/DataHub/Service.asmx";
            //url is optional for scalar and vector sensors, but required for image and html sensors
            sensor.url = sensorURL;
            sensor.keywords = sensorKeywords;
            sensor.description = sensorDescription;

            // register the new sensor
            output = sensorManager.RegisterSensor(userName, passCode, sensor);
            Console.WriteLine(output);

            /*
             * delete the newly registered sensor
             */
            output = sensorManager.DeleteSensor(userName, passCode, originalPublisherName, sensorName);
            Console.WriteLine(output);
        }

        static void ManagerVectorTypesAndSensors(SensorManager.Service sensorManager, string userName, Guid passCode)
        {
            string output;

            /* 
             * register a vector sensor type (component sensor types given by names)
             */
            string vectorSensorTypeName = "yourVectorSenosrTypeName";
            string vectorSensorTypeUri = "yourVectorSenosrTypeUri";
            // define the component types of the vector type by using the names of the component types
            string[] componentTypesByNames = new string[3] { "Temperature", "Humidity", "Pressure" };
            output = sensorManager.CreateVectorSensorType(userName, passCode, vectorSensorTypeName, vectorSensorTypeUri, componentTypesByNames);
            Console.WriteLine(output);

            /* 
             * register a vector sensor type (component sensor types given by ids)
             */
            vectorSensorTypeName = "yourVectorSenosrTypeByIdsName";
            vectorSensorTypeUri = "yourVectorSenosrTypeByIdsUri";
            // define the component types of the vector type by using the Ids of the component types
            int[] componentTypesByIds = new int[3] { 1, 2, 1 };
            output = sensorManager.CreateVectorSensorTypeByIds(userName, passCode, vectorSensorTypeName, vectorSensorTypeUri, componentTypesByIds);
            Console.WriteLine(output);

            /* 
             * register a vector sensor
             */
            // this is a vector sensor of the newly created type - vectorSensorTypeUri
            string vectorSensorName = "yourVectorSensorName";
            string originalPublisherName = "yourPublisherName";
            double latitude = -1;
            double longitude = -1;
            double altitude = -1;
            string sensorURL = "yourSensorURL";
            string sensorKeywords = "yourSensorKeywords";
            string sensorDescription = "yourSensorDescription";

            // decare a new vector sensor
            SensorManager.SensorInfo vectorSensor = new SensorManager.SensorInfo();
            vectorSensor.dataType = "vector";
            vectorSensor.sensorType = vectorSensorTypeUri;
            vectorSensor.publisherName = originalPublisherName;
            vectorSensor.sensorName = vectorSensorName;
            vectorSensor.latitude = latitude;
            vectorSensor.longitude = longitude;
            vectorSensor.altitude = altitude;
            vectorSensor.webServiceUrl = "http://localhost/SenseWebV3/DataHub/Service.asmx";
            vectorSensor.keywords = sensorKeywords;
            vectorSensor.description = sensorDescription;

            // register the new vector sensor
            output = sensorManager.RegisterVectorSensor(userName, passCode, vectorSensor);
            Console.WriteLine(output);

            // delete the newly registered vector sensor
            output = sensorManager.DeleteVectorSensor(userName, passCode, originalPublisherName, vectorSensorName, vectorSensorTypeName);
            Console.WriteLine(output);
        }
        static void Main(string[] args)
        {
            // create an accessor to SensorManager
            SensorManager.Service sensorManager = new SensorManager.Service();
            // create an accessor to UserManager
            UserManager.Service userManager = new UserManager.Service();

            /*
             * authenticate yourself with SenseWeb and get a temporary 
             * passCode (expire in 10 minutes)
             */
            // TODO: replace the fake username and passwd with real ones
            string userName = "yourUserName";
            string passwd = "yourPasswd";
            Guid passCode = userManager.GetPassCode(userName, passwd);

            ManagerNonVectorTypesAndSensors(sensorManager, userName, passCode);
            ManagerVectorTypesAndSensors(sensorManager, userName, passCode);
        }
    }
}
