type store = Store.t
type action = Store.action
type record = Store.record
type choice = Choice.t
type proc = Choice.proc
type value = Choice.value
type heap = Heap.t
type environment = Environment.t
type pattern = Environment.pattern
type definition = Environment.definition
type species = Species.t
type t

val empty : t
val init : environment -> t
val fresh : t -> int * t
val display : bool -> t -> string
val to_string : t -> string
val to_html : t -> string
val add : species -> choice -> t -> t
val remove_delay : value -> float -> t -> (value list*action*proc*t) option
val remove_output :  value -> float -> t -> (value list*action*proc*t) option
val remove_input : value -> float -> t -> (value list*action*proc*float*t) option
val gillespie : t -> (value*float*float) option
val plot : action list -> species list -> t -> int list
val debug : float -> t -> string
val define : value -> pattern list -> definition -> t -> t
val find : value -> t -> (pattern list*definition) option

(** Updates the term with the new time and choose a new putative time step for the given reaction value *)
val flip : float -> value -> t -> t

val get_environment : t -> environment
val get_heap : t -> heap
